<?php

error_reporting(E_ALL ^ E_NOTICE);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// HamLogWeb
//
// Par F5AGL - GRIP 2007-2008
//
// Email : f5agl@zapgillou.fr
//
// Cette cration est mise  disposition selon le Contrat Paternit-Pas d'Utilisation Commerciale-Pas de Modification 2.0 France 
// disponible en ligne http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
// ou par courrier postal  Creative Commons, 171 Second Street, Suite 300, San Francisco, California 94105, USA.
// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Fichier : config.php 
//
// Description : Fichier de configuration
//		 - Ce fichier de configuration ne contient que des variables internes  HamLogWeb non modifies par le webmaster
//		 depuis le Centre de Configuration; ces dernires sont elles stockes dans une table MySQL.
//		 - Il contient galement des fonctions utilisables par l'ensemble des fichiers HamLogWeb
//
// Paramtres : 
//	
//	- aucun
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///																 
/// FONCTION ADIF_LigneCall($ligne)													 
///																 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
/// Cette fonction traite une ligne d'un fichier ADIF.
///
/// Elle retourne true si la ligne ADIF contient un QSO et false sinon
///
/// Dans le cas o il s'agit d'une ligne de QSO, elle retourne via des
/// variables globales les diffrentes infos du QSO :
///
///	qso_call 	: indicatif
///	qso_date 	: date
///	qso_time 	: heure (avec rajout de 00 si heure sur 4 chiffres dans le fichier ADIF HHMM au lieu de HHMMSS)
///	qso_band 	: bande
///	qso_mode 	: mode
///	qso_dxcc 	: numro DXCC selon la norme ADIF (1:canada, etc...)
///	qso_qsl_sent 	: QSL envoye ou pas
///     qso_qsl_rcvd    : QSL reue ou pas
///	qso_name	: nom de l'om
///	qso_qth		: qth de l'om
///
/// Pour le moment, les autres infos du QSO ne sont pas rappatries.
///
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function ADIF_LigneCall($ligne)
	{
	global $qso_call,$qso_date,$qso_time,$qso_band,$qso_mode,$qso_dxcc,$qso_qsl_sent,$qso_qsl_rcvd,$qso_name,$qso_qth;

	$ligne  = " ".$ligne. "FINDELIGNE";

	// Conversation en minuscules afin de tester uniquement les clefs des infos ADIF en minuscule : call, qso_date, etc...
	$lignem = strtolower($ligne);

	// Test si ligne d'un QSO ou pas
	if (strstr($lignem,"<call"))
		{
		$qso_call 	= "";
		$qso_date 	= "";
		$qso_time  	= "";
		$qso_band	= "";
		$qso_mode	= "";
		$qso_dxcc	= "";
		$qso_qsl_sent	= "";	
		$qso_qsl_rcvd	= "";
		$qso_name	= "";
		$qso_qth	= "";

		if ($trouve = strpos($lignem,"<call")) 	
			{ 	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_call     = substr($chaine,strpos($chaine,">")+1,substr($chaine,6,$fincode-6));
			}
	
		if ($trouve = strpos($lignem,"<qso_date")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_date     = substr($chaine,strpos($chaine,">")+1,substr($chaine,10,$fincode-10));
			}

		if ($trouve = strpos($lignem,"<time_on")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_time     = substr($chaine,strpos($chaine,">")+1,substr($chaine,9,$fincode-9));
				// Si heure au format HHMM au lieu de HHMMSS, ajout de 00  la fin
				if (strlen($qso_time)==4) { $qso_time=$qso_time."00"; }
			}

		if ($trouve = strpos($lignem,"<band")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);	
				$qso_band     = strtoupper(substr($chaine,strpos($chaine,">")+1,substr($chaine,6,$fincode-6)));
			}

		if ($trouve = strpos($lignem,"<mode")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_mode     = strtoupper(substr($chaine,strpos($chaine,">")+1,substr($chaine,6,$fincode-6)));
			}

		if ($trouve = strpos($lignem,"<dxcc")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_dxcc     = substr($chaine,strpos($chaine,">")+1,substr($chaine,6,$fincode-6));
			}

		if ($trouve = strpos($lignem,"<qsl_sent")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_qsl_sent = substr($chaine,strpos($chaine,">")+1,substr($chaine,10,$fincode-10));
			}

		if ($trouve = strpos($lignem,"<qsl_rcvd")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_qsl_rcvd = substr($chaine,strpos($chaine,">")+1,substr($chaine,10,$fincode-10));
			}

		if ($trouve = strpos($lignem,"<name")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_name     = substr($chaine,strpos($chaine,">")+1,substr($chaine,6,$fincode-6));
			}

		if ($trouve = strpos($lignem,"<qth")) 	
			{	$chaine	      = substr($ligne,$trouve,strlen($ligne)-$trouve);
				$qso_qth      = substr($chaine,strpos($chaine,">")+1,substr($chaine,5,$fincode-5));
			}

		// Il s'agit d'une ligne QSO du fichier ADIF
		return(true);

		}	
	else
		{ 

		// Il ne s'agit pas d'une ligne QSO du fichier ADIF
		return(false);

		}	
	}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///																 
/// FONCTION QSLNomFic($call) 
/// FONCTION QSLCall($NomFic)													 
///																 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
/// QSLNomFic remplace les caractres / d'un indicatif par @. Elle permet de prparer le call pour crer le nom de fichier
/// associ  une QSL car les caractres / ne peuvent pas composer un nom de fichier. 
/// Ceci permet de grer des call en /P, /M, etc...
///
/// QSLCall effectue l'opration inverse (remplacement de @ par /) pour retrouver le call  partir de la chaine issue du nom de
/// fichier. Fonction non utilise pour le moment.
///
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function QSLNomFic($call)
	{
	$resultat=strtr($call,"/","@");
	return($resultat);
	}

function QSLCall($NomFic)
	{
	$resultat=strtr($NomFic,"@","/");
	return($resultat);
	}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///																 
/// FONCTION AfficherErreur($fin,$Texte) 												 
///																 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
/// Cette fonction affiche un pav erreur avec un texte d'accompagnement. 
///
/// Si $fin=1, la fin du script est provoque (erreur critique, erreur systme dans l'autre cas);
///
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function AfficherErreur($fin,$texte)
	{
	global $site_www, $Prog_Version;

	?>
	<BR><BR>
	<table style="width: 80%; text-align: left; margin-left: auto; margin-right: auto;"border="0" cellpadding="0" cellspacing="0">
  	<tbody><tr><td style="width: 185px; background-color: rgb(255, 204, 204);"><div style="text-align: center;"><img style="width: 88px; height: 88px;" alt=""
 	 src="./img/annuler.png"><br></div>
      	<div style="text-align: center;"><span style="font-family: Comic Sans MS; font-weight: bold;"><?php if ($fin==1) { echo "ERREUR CRITIQUE"; } else { echo "ERREUR SYSTEME"; }?></span></div>
      	</td><td style="width: 782px; background-color: rgb(255, 204, 204);"><span style="font-family: Comic Sans MS;"><small><?php echo $texte ?></small><br>
      	<br></span><div style="text-align: right;"><div style="text-align: left;"><small><small><span style="font-family: Comic Sans MS;">Version HamLogWeb : 
	<?php if ($Prog_Version=="") { echo "non dtecte"; } else { echo $Prog_Version; } ?> - Adresse du site : <?php if ($site_www=="") { echo "non dtecte"; } else { echo $site_www; } ?></span></small></small></div>
        <span style="font-family: Comic Sans MS;"></span></div>
    	</tr>
	<tr align="center"><td style="background-color: rgb(255, 204, 204);" colspan="2" rowspan="1"><small><span style="font-family: Comic Sans MS;"><br>Merci de copier coller le texte ci-dessus et de l'envoyer &agrave; 
	<a href="mailto:f5agl@zapgillou.fr">f5agl@zapgillou.fr</a>pour analyse.</span><br style="font-family: Comic Sans MS;">
      	<span style="font-family: Comic Sans MS;">Accompagnez votre e-mail d'un <span style="text-decoration: underline;">maximum d'informations sur le contexte de l'erreur critique</span> apparue.
	<br style="font-family: Comic Sans MS;"></span><span style="font-family: Comic Sans MS;">Avec tous mes remerciements et d&eacute;sol&eacute; pour la g&egrave;ne occasionn&eacute;e, <br>
	Gilles, F5AGL.<br></span></small></td></tr></tbody></table>

	<?php
	if ($fin==1) { exit(); }
	}





$install=$_GET['install'];  // =oui si config.php charg depuis do_install.php, dans ce cas, pas de table mysql de config


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///																 
/// CHARGEMENT DES VARIABLES DE CONFIGURATION
///
/// Ce pav ralise le chargement des variables de configuration depuis	la table MySQL. En amont, il faut que configmysql.php ait
/// t excut afin d'avoir les informations de connexion  la base MySQL ($db_host, etc...).												 
///																 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

if (!$install)

{

// Connexion au serveur MySQL
$link = @mysql_connect($db_host,$db_login,$db_psw) or AfficherErreur(1,"[config.php] - Impossible de se connecter au serveur MySQL : " . mysql_error());

// Connexion  la base MySQL
$db_selected = @mysql_select_db($db_base, $link); if (!$db_selected) { AfficherErreur(1,"[config.php] - Impossible de slectionner la base de donnes : " . mysql_error()); }

// Lors de l'accs initial sur le site, la langue souhaite est indfinie, elle est donc rcupre dans la table MySQL
if ($langue=="") 
	{ 
	$sql = 'SELECT * FROM `'.$db_table.'_CONFIG` WHERE `NOMVAR` LIKE \'lg_codedefaut\'';
	$result = mysql_query($sql); 
	$ligne=mysql_fetch_row($result);
	if ($ligne[3]=="") { $ligne[3]="fr"; }
	$lg_codedefaut=$ligne[3];
	$langue=$lg_codedefaut; 
	}

// Puis lecture de l'ensemble des donnes de configuration
$sql = 'SELECT * FROM `'.$db_table.'_CONFIG`';

$result = @mysql_query($sql); if (!$result) { AfficherErreur(1,"[config.php] - Problme d'accs  la table ".$db_table."_CONFIG  - Message systme MySQL : " . mysql_error());  }

while ($ligne=mysql_fetch_row($result))
	{
	$i=0;
	while ($i<15)
		{
		$ligne[$i]=stripslashes($ligne[$i]);
		$i=$i+1;
		}
	if (($ligne[4]=="TML") or ($ligne[4]=="FIK"))
		{
		switch ($langue):
			case "fr"	: ${$ligne[1]}=$ligne[5]; break;
			case "uk"	: ${$ligne[1]}=$ligne[6]; break;
			default 	: $langue="fr"; ${$ligne[1]}=$ligne[5]; // si code langue inconnu dans la table CONFIG, alors code fr retenu
			endswitch;
		}
	else
		{
		${$ligne[1]}=$ligne[3];
		}
	}

// fermeture session sur le serveur MySQL
$result = mysql_close($link);  if (!$result) { AfficherErreur(1,"[config.php] - Problme de fermeture de la base MySQL  - Message systme MySQL : " . mysql_error());  }


}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///																 
/// DONNEES DE CONFIGURATION INTERNES AU PROGRAMME
///
/// Ce pav initialise diffrentes variables internes  HamLogWeb, non modifes par le webmaster									 
///																 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

$Prog_Nom			="HamLogWeb";
$Prog_Site			="http://www.zapgillou.fr/hamlogweb";
$Prog_Version			="beta 0.042";
$Prog_Ver			= "42"; // 1000 pour la version 1, etc...
$Prog_Zip			="HLW0040.ZIP";
$Prog_Date			="21/03/2009";
$Prog_Auteur			="F5AGL";
$Prog_Copyright			="Creative Commons licence";

// permet de tracer les visites sur le site, sera repris dans une prochaine version en excluant les visites du webmestre
$Prog_log			=false;

$lg_valide_code[0]		="fr";
$lg_valide_code[1]		="uk";
$lg_valide_code[2]		="#";

$MenuLien[1]			="home.php";
$MenuLien[2]			="logbook.php";
$MenuLien[3]			="blog.php";
$MenuLien[4]			="infoqsl.php";
$MenuLien[5]			="qslcards.php";
$MenuLien[6]			="livredor.php";
$MenuLien[7]			="diplomes.php";
$MenuLien[8]			="#";

$liste_police_code[0]		="Arial";				$liste_police_libelle[0]	 = $liste_police_code[0];
$liste_police_code[1]		="Arial Black";				$liste_police_libelle[1]	 = $liste_police_code[1];
$liste_police_code[2]		="Broadway BT";				$liste_police_libelle[2]	 = $liste_police_code[2];
$liste_police_code[3]		="Comic Sans MS";			$liste_police_libelle[3]	 = $liste_police_code[3];
$liste_police_code[4]		="Courier";				$liste_police_libelle[4]	 = $liste_police_code[4];
$liste_police_code[5]		="Fixedsys";				$liste_police_libelle[5]	 = $liste_police_code[5];
$liste_police_code[6]		="Georgia";				$liste_police_libelle[6]	 = $liste_police_code[6];
$liste_police_code[7]		="Impact";				$liste_police_libelle[7]	 = $liste_police_code[7];
$liste_police_code[8]		="Lucida Console";			$liste_police_libelle[8]	 = $liste_police_code[8];
$liste_police_code[9]		="Roman";				$liste_police_libelle[9]  	 = $liste_police_code[9];
$liste_police_code[10]		="System";				$liste_police_libelle[10] 	 = $liste_police_code[10];
$liste_police_code[11]		="Tahoma";				$liste_police_libelle[11] 	 = $liste_police_code[11];
$liste_police_code[12]		="Verdana";				$liste_police_libelle[12] 	 = $liste_police_code[12];
$liste_police_code[13]		="Helvetica,Arial,sans-serif";		$liste_police_libelle[13] 	 = $liste_police_code[13];
$liste_police_code[14]		="Times New Roman,Times,serif";		$liste_police_libelle[14]	 = $liste_police_code[14];
$liste_police_code[15]		="#";					$liste_police_libelle[14]	 = $liste_police_code[14];

$qslcards_cellulehauteur	=40; 					// en px
$qslcards_vignette		=150;					// largeur en px
$qslcards_largeur		=600;					// utilis pour centrer l'affichage de la QSL lors du survol de la vignette
$qslcards_hauteur		=389;					// utilis pour centrer l'affichage de la QSL lors du survol de la vignette

// DIMENSIONS
$VoletGauche_Taille		="15%";
$Taille_PanneauCentral_Marge	="4%";
$Taille_PanneauCentral_QSO_Larg ="50%";
$Taille_PanneauCentral_QSL_Larg ="50%";
$Taille_PanneauCentral_Log_Date ="17%";
$Taille_PanneauCentral_Log_Time ="8%";
$Taille_PanneauCentral_Log_Call ="20%";
$Taille_PanneauCentral_Log_Band ="8%";
$Taille_PanneauCentral_Log_Mode ="8%";
$Taille_Logbook_Log		="9%";
$Taille_Logbook_Date		="9%";
$Taille_Logbook_Time		="7%";
$Taille_Logbook_Indicatif	="13%";
$Taille_Logbook_SaQSL		="5%";
$Taille_Logbook_Bande		="7%";
$Taille_Logbook_Mode		="7%";
$Taille_Logbook_MaQSL		="5%";
$Taille_Logbook_Cote		="3%";
$Taille_Logbook_Total		="100%";

$Taille_InfoQSL_LargeurQSL	="45%";
$Taille_Pied_hauteur		="4%";
$Taille_Pied_Email_Largeur	="30%";
$Taille_Pied_ZoneDroite_Largeur ="70%";
$Taille_Blog_Largeur		="96%";
$Taille_IconeDrapeau		="3%";
$Taille_IconeDrapeauVoletGauche	="15%";




////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///																 
/// DONNEES LINGUISTIQUES INTERNES AU PROGRAMME
///
/// Ce pav initialise diffrentes variables linguistiques internes  HamLogWeb, non modifes par le webmaster									 
///																 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

if ($langue=="fr")
	{
	$lg_fichierdrapeau		="./img/drapeaufr.gif";
	$lg_code			="fr";

	// Nom des langues
	$lg_valide_code_libelle[0]	="franais";
	$lg_valide_code_libelle[1]	="anglais";

	// ENTETE
	$lg_entete_qsointhelog		="QSO dans le log";
	$lg_entete_dxccentities		="Contres DXCC";
	$lg_entete_worked		="contactes";
	$lg_entete_confirmed		="confirmes";
	$lg_entete_derniereMAJ		="Dernire mise  jour :";

	// HOME
	$lg_home_NewInTheBlog		="Les derniers articles dans le blog";	
	$lg_home_LastContacts		="Derniers contacts dans le log";
	$lg_home_LastQSL		="Dernires cartes QSL reues";	
	$lg_home_QuickSearch		="Etes-vous dans le log ?";

	// DIPLOMES
	$lg_diplomes_selectdxcc		="Choisissez un bilan DXCC";
	$lg_Filtrage_InfobulleShow	="Visualiser";
	$lg_notworked			="non contacts";
	$lg_worked			="contacts";
	$lg_confirmed			="confirms";
	$lg_totaux			="TOTAUX";

	// LOGBOOK
	$lg_logbook_previouspage	="page prcdente";
	$lg_logbook_firstpage		="premire page";
	$lg_logbook_nextpage		="page suivante";
	$lg_logbook_lastpage		="dernire page";
	$lg_logbook_search		="chercher";
	$lg_logbook_sorrynoqso		="Dsol, aucun QSO trouv !";	
	$lg_formatdate          	="fr";
	$lg_Filtrage_TousDXCC		="Toutes contres";
	$lg_Filtrage_TousLog		="Tous";
	$lg_Filtrage_InfobulleGo	="Rechercher";

	// QSL CARDS
	$lg_qslcards_search		="Chercher les cartes QSL de ce DXCC";
	$lg_qslcards_justclick		="Cliquez sur une carte QSL pour la voir en grande taille !";

	// EN TRAVAUX
	$lg_entravaux_titre		="... EN TRAVAUX ...";
	$lg_entravaux_texte		="revenez bientt !";

	// PIED
	$lg_pied_siteresolution		="Site optimis pour une rsolution minimale de 1280*800";

	// TABLEAU LOG
	$lg_log_date			="DATE";
	$lg_log_time			="HEURE";
	$lg_log_call			="INDICATIF";
	$lg_log_band			="BANDE";
	$lg_log_mode			="MODE";
	$lg_log_dxcc			="DXCC";
	$lg_log_hisqsl			="SA QSL";
	$lg_log_myqsl			="MA QSL";

	// PAGE NON DISPONIBLE DANS CETTE LANGUE
	$lg_languagenoavailable		="Dsol, cette page n'est pas disponible en franais.";

	// PAGE LIVRE DOR
	$lg_indicatif			="Indicatif et/ou prnom";
	$lg_msg				="Votre message :";
	$lg_entercode			="Recopiez le code :";
	$lg_envoi			="ENVOYER";
	$lg_cliquerici          	="CLIQUEZ ICI !";
	$lg_codeerrone			="ATTENTION, message non enregistr, code erron";
	$lg_codeok			="Votre message a bien t enregistr. Merci !";

	// CENTRE DE CONFIGURATION
	$lg_CDC_titre			="Centre de configuration";
	$lg_CDC_par			="par";
	
	$lg_CDC_avertissement		="AVERTISSEMENT";
	$lg_CDC_avertissementlgn1	="AUCUN MOT DE PASSE EST DEFINI POUR L'ACCES AU CENTRE DE CONFIGURATION";
	$lg_CDC_avertissementlgn2	="VOUS ETES VIVEMENT ENCOURAGES A EN DEFINIR UN EN CLIQUANT";

	$lg_CDC_menuhome		="accueil";
	$lg_CDC_menuretour		="retour au site";
	$lg_CDC_menuparametres		="Paramtres :";
	$lg_CDC_menugnraux		="gnraux";
	$lg_CDC_menulinguistiques	="linguistiques";
	$lg_CDC_menucouleurs		="couleurs";
	$lg_CDC_menumenu		="menu";
	$lg_CDC_menuconfigpages		="Configuration des pages :";
	$lg_CDC_menuentete		="entete";
	$lg_CDC_menuaccueil		="accueil";
	$lg_CDC_menulogbook		="logbook";
	$lg_CDC_menublog		="blog";
	$lg_CDC_menuinfoQSL		="info QSL";
	$lg_CDC_menucartesQSL		="cartes QSL";
	$lg_CDC_menulivredor		="livre d'or";
	$lg_CDC_menudiplomes		="diplomes";
	$lg_CDC_menucontenu		="Contenu :";
	$lg_CDC_menugestionlog		="gestion log";
	$lg_CDC_menugestionqsl		="gestion qsl";

	$lg_CDC_francais		="Franais :";
	$lg_CDC_anglais			="Anglais :";
	$lg_CDC_validation		="Validation";
	$lg_CDC_parcourir		="Parcourir";
	$lg_CDC_suppression		="Suppression";
	$lg_CDC_SUPPRESSION		="SUPPRESSION";
	$lg_CDC_Date			="Date";
	$lg_CDC_Heure			="Heure";
	$lg_CDC_Indicatif		="Indicatif";
	$lg_CDC_ici			="ICI";
	$lg_CDC_Bande			="Bande";
	$lg_CDC_Mode			="Mode";
	$lg_CDC_Associer		="ASSOCIER";
	$lg_CDC_SELECTION		="SELECTION";
	$lg_CDC_MiseAJourEffectuee	="... MISE A JOUR EFFECTUEE ...";
	$lg_CDC_ThemeSauvegarde		="... THEME SAUVEGARDE : ";
	$lg_CDC_ThemeCharge		="... THEME CHARGE : ";

	$lg_CDC_paramgeneraux		="PARAMETRES GENERAUX";

	$lg_CDC_paramlinguistiques	="PARAMETRES LINGUISTIQUES";

	$lg_CDC_paramcouleurs		="PARAMETRES COULEURS";
	$lg_CDC_paramcouleurscharg	="Chargement d'un thme";
	$lg_CDC_paramcouleurssauv	="Sauvegarde du thme";
	$lg_CDC_paramcouleursnochg	="pas de chargement";

	$lg_CDC_parammenu		="PARAMETRES MENU";
	$lg_CDC_parammenupagessup	="Pages supplmentaires :";
	$lg_CDC_parammenulibelle	="Libell dans le menu latral";
	$lg_CDC_parammenufichierhtml	="Fichier html ou lien direct";
	$lg_CDC_parammenusupplien	="suppresion du lien vers cette page :";
	$lg_CDC_parammenuedition	="EDITION";

	$lg_CDC_paramentete		="CONFIGURATION PAGE ENTETE";
	$lg_CDC_paramenteteactuellement	="actuellement :";
	
	$lg_CDC_paramaccueil		="CONFIGURATION PAGE ACCUEIL";
	
	$lg_CDC_paramlogbook		="CONFIGURATION PAGE LOGBOOK";

	$lg_CDC_paraminfoqsl		="CONFIGURATION PAGE INFO QSL";

	$lg_CDC_paramcartesqsl		="CONFIGURATION PAGE CARTES QSL";

	$lg_CDC_paramlivredor		="CONFIGURATION PAGE LIVRE D'OR";
	$lg_CDC_paramlivredorAuteur	="Message de";

	$lg_CDC_diplomedxcc		="DXCC";
	$lg_CDC_diplomedxcctitre	="DIPLOME DXCC";

	$lg_CDC_gestlogtitre		="GESTION DES LOGS";
	$lg_CDC_gestlogimport		="Import d'un log";
	$lg_CDC_gestlogsuppression	="Suppression d'un log";
	$lg_CDC_gestlogselection	="Slection du log principal";
	$lg_CDC_gestloginfo		="Informations";
	$lg_CDC_gestloglgn01		="Slection du fichier LOG  traiter";
	$lg_CDC_gestloglgn02		="Upload d'un log au format";
	$lg_CDC_gestloglgn03		="ou";
	$lg_CDC_gestloglgn04		="traitement d'un log dj sur le serveur";
	$lg_CDC_gestloglgn05		="Import multi-requtes";
	$lg_CDC_gestloglgn06		="Indicatif(s) prsent(s) dans le log";
	$lg_CDC_gestloglgn07		="Affichage de la date associe aux QSO";
	$lg_CDC_gestloglgn08		="Affichage de l'heure associe aux QSO";
	$lg_CDC_gestloglgn09		="Description du log";
	$lg_CDC_gestloglgn10		="Slection de l'indicatif associ";
	$lg_CDC_gestloglgn11		="Informations diverses";
	$lg_CDC_gestloglgn12		="Slection du fichier LOG  supprimer";
	$lg_CDC_gestloglgn13		="Indicatif associ dans le log";
	$lg_CDC_gestloglgn14		="Dfinissez ici le log principal de votre site";
	$lg_CDC_gestloglgn15		="Le log principal de votre site HamLogWeb correspond au log affich en page d'accueil et utilis pour les statistiques (DXCC, diplmes, etc...).";
	$lg_CDC_gestloglgn16		="Les autres logs sont visibles en page Logbook de votre site par l'intermdiaire de cases  cocher.";
	$lg_CDC_gestloglgn17		="Slection du log principal";
	$lg_CDC_gestloglgn18		="log principal";
	$lg_CDC_gestloglgn19		="Nouvel indicatif";
	$lg_CDC_gestloglgn20		="QSO non associs";
	
	$lg_CDC_gestqsltitre		="GESTION DES QSLS";
	$lg_CDC_gestqslimport		="Import d'une QSL";
	$lg_CDC_gestqslsuppression	="Suppression de QSL(s)";
	$lg_CDC_gestqsllgn01		="Slection de la QSL  importer";
	$lg_CDC_gestqsllgn02		="Upload d'une QSL";
	$lg_CDC_gestqsllgn03		="format JPG";
	$lg_CDC_gestqsllgn04		="(dimensions : 600 pixels * 380 pixels)";
	$lg_CDC_gestqsllgn05		="Slection de l'indicatif associ";
	$lg_CDC_gestqsllgn06		="Filtre indicatif";
	$lg_CDC_gestqsllgn07		="Suppression des QSLs associes aux QSOs suivants :";
	$lg_CDC_gestqsllgn08		="Import d'une QSL au format JPG : ";
	$lg_CDC_gestqsllgn09		="Nom du fichier : ";
	$lg_CDC_gestqsllgn10		="Le fichier JPG est absent.";
	$lg_CDC_gestqsllgn11		="Slection des QSO  associer  cette QSL";
	$lg_CDC_gestqsllgn12		="Cochez pour slectionner le QSO";
	$lg_CDC_gestqsllgn13		="Aucun QSO trouv";
	$lg_CDC_gestqsllgn14		="Aucun QSO  rattacher  cette QSL : suppression fichier JPG";
	$lg_CDC_gestqsllgn15		="Erreur import fichier JPG";
	$lg_CDC_gestqsllgn16		="Association QSL <=> QSO";
	$lg_CDC_gestqsllgn17		="Cration vignette de la QSL";
	$lg_CDC_gestqsllgn18		="Association de la QSL au QSO avec";
	$lg_CDC_gestqsllgn19		="Aucun QSO rattach  cette QSL : suppression fichier JPG et vignette associe";
	$lg_CDC_gestqsllgn20		="Fin de traitement";
	$lg_CDC_gestqsllgn21		="Suppression d'un fichier non rattach  un QSO : ";
	$lg_CDC_gestqsllgn22		="Suppression de l'association QSL <=> QSO ";
	$lg_CDC_gestqsllgn23		="Suppression des fichiers QSL orphelins";
	$lg_CDC_gestqsllgn24		="Mise  jour des statistiques du log principal :";
	$lg_CDC_gestqsllgn25		="Nb de QSO dans le log de ";
	$lg_CDC_gestqsllgn26		="Nb de DXCC contacts dans le log de ";
	$lg_CDC_gestqsllgn27		="Nb de DXCC confirmes dans le log de ";
	$lg_CDC_gestqsllgn28		="Association du log principal  l'indicatif d'appel : ";
	$lg_CDC_gestqsllgn29		="Association effectue";
	$lg_CDC_gestqsllgn30		="Import d'un log - Dbut de traitement";
	$lg_CDC_gestqsllgn31		="Upload d'un fichier log au format ADIF : ";
	$lg_CDC_gestqsllgn32		="Echec d'import du fichier log";
	$lg_CDC_gestqsllgn33		="Import d'un fichier log au format ADIF prsent sur le serveur : ";
	$lg_CDC_gestqsllgn34		="Import impossible, aucun indicatif d'import dfini";
	$lg_CDC_gestqsllgn35		="Indicatif d'import du log : ";
	$lg_CDC_gestqsllgn36		="Dversement du log dans la table MySQL : ";
	$lg_CDC_gestqsllgn37		="Mise  jour liste des DXCC contacts pour les recherches ultrieures";
	$lg_CDC_gestqsllgn38		="Mise  jour des rfrences DXCC des QSL";
	$lg_CDC_gestqsllgn39		="Le QSO associ  la QSL suivante est introuvable dans le log : ";
	$lg_CDC_gestqsllgn40		="Mise  jour du DXCC associ  la QSL suivante : ";
	$lg_CDC_gestqsllgn41		="Aucun import effectu";
	$lg_CDC_gestqsllgn42		="Suppression des QSO rattachs  l'indicatif d'appel : ";

	$lg_CDC_licence1		="Distribu sous";
	$lg_CDC_licence2		="creative Commons Licence";

	$lg_CDC_Error01			="[admin.php] - Impossible de se connecter au serveur MySQL : ";
	$lg_CDC_Error02			="[admin.php] - Impossible de slectionner la base de donnes : ";
	$lg_CDC_Error03			="[admin.php] - Problme d'accs  la table ";
	$lg_CDC_Error04			="Message systme MySQL : ";
	
	}

if ($langue=="uk")
	{
	$lg_fichierdrapeau		="./img/drapeauuk.gif";
	$lg_code			="uk";

	// Nom des langues
	$lg_valide_code_libelle[0]	="french";
	$lg_valide_code_libelle[1]	="english";

	// ENTETE
	$lg_entete_qsointhelog		="QSO in the log";
	$lg_entete_dxccentities		="DXCC entities";
	$lg_entete_worked		="worked";
	$lg_entete_confirmed		="confirmed";
	$lg_entete_derniereMAJ		="Last update :";

	// HOME
	$lg_home_NewInTheBlog		="New in the blog";	
	$lg_home_LastContacts		="Last contacts on the log";
	$lg_home_LastQSL		="Last received QSL cards";
	$lg_home_QuickSearch		="Are you in the log ?";	

	// DIPLOMES
	$lg_diplomes_selectdxcc		="Select a DXCC type";
	$lg_Filtrage_InfobulleShow	="Show";
	$lg_notworked			="not worked";
	$lg_worked			="worked";
	$lg_confirmed			="confirmed";
	$lg_totaux			="SUMS";

	// LOGBOOK
	$lg_logbook_previouspage	="previous page";
	$lg_logbook_firstpage		="first page";
	$lg_logbook_nextpage		="next page";
	$lg_logbook_lastpage		="last page";
	$lg_logbook_search		="search";
	$lg_logbook_sorrynoqso		="Sorry, any QSO found !";	
	$lg_formatdate          	="uk";
	$lg_Filtrage_TousDXCC		="All entities";
	$lg_Filtrage_TousLog		="All";
	$lg_Filtrage_InfobulleGo	="Search";

	// QSL CARDS
	$lg_qslcards_search		="Search QSL cards of this DXCC";
	$lg_qslcards_justclick		="Just click on a QSL to see or hide it !";

	// EN TRAVAUX
	$lg_entravaux_titre		="... UNDER CONSTRUCTION ...";
	$lg_entravaux_texte		="come again !";

	// PIED
	$lg_pied_siteresolution		="This site is optimized for viewing at 1280*800 resolution";

	// TABLEAU LOG
	$lg_log_date			="DATE";
	$lg_log_time			="TIME";
	$lg_log_call			="CALL";
	$lg_log_band			="BAND";
	$lg_log_mode			="MODE";
	$lg_log_dxcc			="DXCC";
	$lg_log_hisqsl			="HIS QSL";
	$lg_log_myqsl			="MY QSL";

	// PAGE NON DISPONIBLE DANS CETTE LANGUE
	$lg_languagenoavailable		="Sorry, this page is not available in english.";

	// PAGE LIVRE DOR
	$lg_indicatif			="Call and/or name";
	$lg_msg				="Your message :";
	$lg_entercode			="Enter the code :";
	$lg_envoi			="SEND";
	$lg_cliquerici          	="CLICK HERE !";
	$lg_codeerrone			="WARNING, message not saved, wrong code";
	$lg_codeok			="Your message is saved. Thanks !";

	// CENTRE DE CONFIGURATION
	$lg_CDC_titre			="Configuration Center";
	$lg_CDC_par			="par";
	
	$lg_CDC_avertissement		="WARNING";
	$lg_CDC_avertissementlgn1	="ANY PASSWORD IS DEFINED FOR THE ACCESS IN THE CONFIGURATION CENTER";
	$lg_CDC_avertissementlgn2	="YOU ARE DEEPLY ENCOURAGED TO DEFINE ONE BY CLICKING";

	$lg_CDC_menuhome		="home";
	$lg_CDC_menuretour		="return to your web site";
	$lg_CDC_menuparametres		="General configuration :";
	$lg_CDC_menugnraux		="Main";
	$lg_CDC_menulinguistiques	="Language";
	$lg_CDC_menucouleurs		="Colors";
	$lg_CDC_menumenu		="Menus";
	$lg_CDC_menuconfigpages		="Pages configuration :";
	$lg_CDC_menuentete		="header";
	$lg_CDC_menuaccueil		="home";
	$lg_CDC_menulogbook		="logbook";
	$lg_CDC_menublog		="blog";
	$lg_CDC_menuinfoQSL		="QSL info";
	$lg_CDC_menucartesQSL		="QSL cards";
	$lg_CDC_menulivredor		="guestbook";
	$lg_CDC_menudiplomes		="awards";
	$lg_CDC_menucontenu		="Contents :";
	$lg_CDC_menugestionlog		="log management";
	$lg_CDC_menugestionqsl		="qsl management";

	$lg_CDC_francais		="French :";
	$lg_CDC_anglais			="English :";
	$lg_CDC_validation		="Validate";
	$lg_CDC_parcourir		="Search";
	$lg_CDC_suppression		="Delete";
	$lg_CDC_SUPPRESSION		="DELETE";
	$lg_CDC_Date			="Date";
	$lg_CDC_Heure			="Time";
	$lg_CDC_Indicatif		="Call";
	$lg_CDC_ici			="HERE";
	$lg_CDC_Bande			="Band";
	$lg_CDC_Mode			="Mode";
	$lg_CDC_Associer		="LINK";
	$lg_CDC_SELECTION		="SELECT";
	$lg_CDC_MiseAJourEffectuee	="... UPDATING DONE ...";
	$lg_CDC_ThemeSauvegarde		="... COLOR SET SAVED : ";
	$lg_CDC_ThemeCharge		="... COLOR SET LOADED : ";

	$lg_CDC_paramgeneraux		="MAIN CONFIGURATION";

	$lg_CDC_paramlinguistiques	="LANGUAGE CONFIGURATION";

	$lg_CDC_paramcouleurs		="COLORS CONFIGURATION";
	$lg_CDC_paramcouleurscharg	="Load colors model";
	$lg_CDC_paramcouleurssauv	="Save colors model";
	$lg_CDC_paramcouleursnochg	="No load";

	$lg_CDC_parammenu		="MENUS CONFIGURATION";
	$lg_CDC_parammenupagessup	="Adding pages :";
	$lg_CDC_parammenulibelle	="Side menu title";
	$lg_CDC_parammenufichierhtml	="HTML file or direct link";
	$lg_CDC_parammenusupplien	="delete this link :";
	$lg_CDC_parammenuedition	="EDIT";

	$lg_CDC_paramentete		="CONFIGURATION OF ENTETE PAGE";
	$lg_CDC_paramenteteactuellement	="now :";
	
	$lg_CDC_paramaccueil		="CONFIGURATION OF HOME PAGE";
	
	$lg_CDC_paramlogbook		="CONFIGURATION OF LOGBOOK PAGE";

	$lg_CDC_paraminfoqsl		="CONFIGURATION OF INFO QSL PAGE";

	$lg_CDC_paramcartesqsl		="CONFIGURATION OF QSL CARDS PAGE";

	$lg_CDC_paramlivredor		="CONFIGURATION OF GUESTBOOK";
	$lg_CDC_paramlivredorAuteur	="Message from";

	$lg_CDC_diplomedxcc		="DXCC";
	$lg_CDC_diplomedxcctitre	="DXCC AWARD";

	$lg_CDC_gestlogtitre		="LOGS MANAGEMENT";
	$lg_CDC_gestlogimport		="Import a log";
	$lg_CDC_gestlogsuppression	="Delete a log";
	$lg_CDC_gestlogselection	="Select main log";
	$lg_CDC_gestloginfo		="Informations";
	$lg_CDC_gestloglgn01		="Selection of LOG file";
	$lg_CDC_gestloglgn02		="Upload of a file LOG";
	$lg_CDC_gestloglgn03		="or";
	$lg_CDC_gestloglgn04		="import a log already on the server";
	$lg_CDC_gestloglgn05		="Several requests import";
	$lg_CDC_gestloglgn06		="Call already on the log";
	$lg_CDC_gestloglgn07		="Show QSO's date";
	$lg_CDC_gestloglgn08		="Show QSO's time";
	$lg_CDC_gestloglgn09		="Log description";
	$lg_CDC_gestloglgn10		="Select the associated call";
	$lg_CDC_gestloglgn11		="Tell me also...";
	$lg_CDC_gestloglgn12		="Select the log you want to delete";
	$lg_CDC_gestloglgn13		="Associated call";
	$lg_CDC_gestloglgn14		="Define here the main call of your";
	$lg_CDC_gestloglgn15		="The main log is the one use on home page and for statistics (DXCC, awards, etc...).";
	$lg_CDC_gestloglgn16		="Other logs are viewable on logbook page.";
	$lg_CDC_gestloglgn18		="Main log";
	$lg_CDC_gestloglgn19		="New call";
	$lg_CDC_gestloglgn20		="Not associated QSO";
	$lg_CDC_gestqsllgn21		="Deleting a file not linked with a QSO : ";
	$lg_CDC_gestqsllgn22		="Deleting the link QSL <=> QSO ";
	$lg_CDC_gestqsllgn23		="Deleting orphan QSL";
	$lg_CDC_gestqsllgn24		="Updating statistics of the main log :";
	$lg_CDC_gestqsllgn25		="QSO in the log of ";
	$lg_CDC_gestqsllgn26		="DXCC worked in the log of  ";
	$lg_CDC_gestqsllgn27		="DXCC confirmed in the log of ";
	$lg_CDC_gestqsllgn28		="The main log is now : ";
	$lg_CDC_gestqsllgn29		="Main log changed";
	$lg_CDC_gestqsllgn30		="Import a log";
	$lg_CDC_gestqsllgn31		="ADIF file upload : ";
	$lg_CDC_gestqsllgn32		="Failed to upload log file";
	$lg_CDC_gestqsllgn33		="Import a log file already in the server : ";
	$lg_CDC_gestqsllgn34		="Failed to import - no callsign defined";
	$lg_CDC_gestqsllgn35		="Callsign : ";
	$lg_CDC_gestqsllgn36		="Upload log on the MySQL table : ";
	$lg_CDC_gestqsllgn37		="Updating DXCC contacted";
	$lg_CDC_gestqsllgn38		="Updating DXCC informations for QSLs";
	$lg_CDC_gestqsllgn39		="No QSO associated on the log with this QSL : ";
	$lg_CDC_gestqsllgn40		="Updating DXCC information of this QSL : ";
	$lg_CDC_gestqsllgn41		="No import done";	


	$lg_CDC_gestqsltitre		="QSLS MANAGEMENT";
	$lg_CDC_gestqslimport		="Import QSL";
	$lg_CDC_gestqslsuppression	="Delete QSL(s)";
	$lg_CDC_gestqsllgn01		="Select the QSL you want to import";
	$lg_CDC_gestqsllgn02		="QSL upload";
	$lg_CDC_gestqsllgn03		="JPG file format";
	$lg_CDC_gestqsllgn04		="(600 pixels * 380 pixels)";
	$lg_CDC_gestqsllgn05		="Select the associated call";
	$lg_CDC_gestqsllgn06		="Call filter";
	$lg_CDC_gestqsllgn07		="Delete QSLs associated with following QSOs :";
	$lg_CDC_gestqsllgn08		="Import of a JPG QSL file : ";
	$lg_CDC_gestqsllgn09		="File name : ";
	$lg_CDC_gestqsllgn10		="JPG file is absent.";
	$lg_CDC_gestqsllgn11		="Select QSO to be associated with this QSL";
	$lg_CDC_gestqsllgn12		="Check for QSO select";
	$lg_CDC_gestqsllgn13		="No QSO found";
	$lg_CDC_gestqsllgn14		="No QSO to link with this QSL : deleting JPG file";
	$lg_CDC_gestqsllgn15		="Error during JPG file import";
	$lg_CDC_gestqsllgn16		="Link creation between QSL & QSO";
	$lg_CDC_gestqsllgn17		="QSL's thunderbail creation";
	$lg_CDC_gestqsllgn18		="Associate this QSL with QSO : ";
	$lg_CDC_gestqsllgn19		="No QSO linked with this QSL : deleting JPG file and thunderbail";
	$lg_CDC_gestqsllgn20		="End of batch";
	$lg_CDC_gestqsllgn21		="Deleting a QSL file not linked with a QSO : ";
	$lg_CDC_gestqsllgn22		="Deleting of a link QSO <=> QSL ";
	$lg_CDC_gestqsllgn23		="Deleting orphan QSL's files";

	$lg_CDC_licence1		="Distributed under";
	$lg_CDC_licence2		="creative Commons Licence";

	$lg_CDC_Error01			="[admin.php] - Error during connexion to MySQL server : ";
	$lg_CDC_Error02			="[admin.php] - Error during connexion to database : ";
	$lg_CDC_Error03			="[admin.php] - Error during connexion to table ";
	$lg_CDC_Error04			="MySQL internal message : ";
	}


return $Prog_Ver;

?>

